/*
 * Decompiled with CFR 0.152.
 */
package ImageResize;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Tools {
    private static DecimalFormat df = new DecimalFormat("0.00");

    public static List<File> openFiles(Window ownerWindow) {
        FileChooser fc = new FileChooser();
        fc.setTitle("K\u00e9p f\u00e1jlok megny\u00edt\u00e1sa");
        fc.setInitialDirectory(new File(System.getProperty("user.home")));
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("BMP", new String[]{"*.bmp"})});
        return fc.showOpenMultipleDialog(ownerWindow);
    }

    public static File openWaterMarkFile(Window ownerWindow) {
        FileChooser fc = new FileChooser();
        fc.setTitle("V\u00edzjel k\u00e9p f\u00e1jl megny\u00edt\u00e1sa");
        fc.setInitialDirectory(new File(System.getProperty("user.home")));
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"}), new FileChooser.ExtensionFilter("BMP", new String[]{"*.bmp"})});
        return fc.showOpenDialog(ownerWindow);
    }

    public static void ownAlert(int value, Window owner) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("\u00c9rv\u00e9nytelen \u00e9rt\u00e9k");
        alert.setHeaderText("A megadott \u00e9rt\u00e9k \u00e9rv\u00e9nytelen! (" + value + ")");
        alert.setContentText("Az \u00e9rv\u00e9nyes \u00e9rt\u00e9ktartom\u00e1ny: 10 - 4096");
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static void noRead(String name, Window owner) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Olvas\u00e1si hiba");
        alert.setHeaderText(null);
        alert.setContentText("A k\u00e9p nem olvashat\u00f3! \n" + name);
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static void noImages(Window owner) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Nincs k\u00e9p");
        alert.setHeaderText(null);
        alert.setContentText("Nincs megnyitva k\u00e9p!");
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static void defError(Window owner) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Hiba");
        alert.setHeaderText(null);
        alert.setContentText("Hiba a k\u00e9pek feldolgoz\u00e1sa k\u00f6zben!");
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static boolean confirmDelete(Window owner) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("T\u00f6rl\u00e9s meger\u0151s\u00edt\u00e9se");
        alert.setHeaderText(null);
        alert.initOwner(owner);
        alert.setContentText("Biztosan t\u00f6r\u00f6lni szeretn\u00e9 az eredeti f\u00e1jlokat?  \nA t\u00f6rl\u00e9s v\u00e9gleges, a t\u00f6rl\u00e9st k\u00f6vet\u0151en azok \nnem \u00e9rhet\u0151ek el...");
        ButtonType buttonTypeIgen = new ButtonType("Igen");
        ButtonType buttonTypeNem = new ButtonType("Nem");
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeIgen, buttonTypeNem});
        Optional result = alert.showAndWait();
        return result.get() == buttonTypeIgen;
    }

    public static void failedDelete(String dir, Window owner) {
        Alert alertError = new Alert(Alert.AlertType.ERROR);
        alertError.setTitle("T\u00f6rl\u00e9si hiba");
        alertError.setHeaderText("A k\u00e9pek elt\u00e1vol\u00edt\u00e1sa nem volt teljes k\u00f6r\u0171!");
        alertError.setContentText("\"K\u00e9rem ellen\u0151rize manu\u00e1lisan a k\u00f6nyvt\u00e1rat: \n" + dir);
        alertError.initOwner(owner);
        alertError.showAndWait();
    }

    public static void about(Window owner) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Csoportos k\u00e9p\u00e1tm\u00e9retez\u0151 alkalmaz\u00e1s");
        alert.setHeaderText("K\u00e9sz\u00fclt: \nL\u00e1z\u00e1r Istv\u00e1n \nINIT KEMIF EAIO \nKreativRegio (https://kreativregio.hu) \n2018");
        alert.setContentText("ver.: 1.1");
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static void previewWindow(File file, Window owner) {
        Image inputPreImg = null;
        if (file != null) {
            try {
                FileInputStream input = new FileInputStream(file);
                inputPreImg = new Image((InputStream)input);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        StackPane secondaryLayout = new StackPane();
        Scene secondScene = new Scene((Parent)secondaryLayout, 600.0, 400.0);
        BorderPane pane = new BorderPane();
        ImageView iw = new ImageView();
        iw.fitWidthProperty().bind((ObservableValue)secondScene.widthProperty());
        iw.fitHeightProperty().bind((ObservableValue)secondaryLayout.heightProperty());
        iw.setPreserveRatio(true);
        iw.setImage(inputPreImg);
        pane.setCenter((Node)iw);
        secondaryLayout.getChildren().add((Object)pane);
        Stage newWindow = new Stage();
        newWindow.initModality(Modality.APPLICATION_MODAL);
        newWindow.setTitle("El\u0151n\u00e9zet");
        newWindow.setScene(secondScene);
        newWindow.initOwner(owner);
        newWindow.show();
    }
}

